/*-------------------------------------------------------------------------*\

  FILE..: TCID.CPP
  AUTHOR: David Rowe
  DATE..: 23/4/01

  Unit test program for testing Caller ID decoding module.  Used to test
  if packet demodulated OK during channel impairment tests.  If packet
  not demodulated OK, usually get failure in Data Link Layer, resulting
  in exception.

  Method:
  1. Set up channel params in tsig.m
  2. Run tsig;demod3 in Matlab, demod3 outputs the file demodani.txt
  3. Run this program, with demodani.txt as the input.
  4. Record pass/fail.
  
  Results: 25/4/01, DR

  SNR(dB) Level(dbM0)	delta	imb	Toff(%)	Result

  100		-30	0	0	0	OK	amp +/-1000
  100		-40	0	0	0	OK	amp +/-300
  100		-50	0	0	0	Fail	amp 0! (no signal)
  8		-40	1%	+6	0	OK
  8		-40	1%	+6	1	Fail
  8		-30	1%	+6	1	OK
  12		-30	1%	+6	1	OK
  12		-40	1%	+6	1	OK
  12		-40	-1%	-6	-1	OK
  8		-20	-1%	-6	-1	OK

  Notes:
  1. Linear 8-bit codec simulated in tsig.m, worse than alaw so real-world
     results should be at least as good.
  2. V4PCI hardware should give level about -24dBm0, or +/-3000, which is
     within dynamic range.
  3. SNR should be > 12dB in practice.
  4. Debug data can be viewed in the debug file (see vpb_cid_debug_on()) call
     below.  This contains bit stream and ASCII chars.
  5. Above table of results was obtained using Matlab demod - C demod
     was tested with very similar performance.

\*-------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "../src/vpbapi.h"
#include "../src/wobbly.h"

void extract_presentation_layer_message(
		char  *pres,		// output array of pres layer data
		int   *npres,		// number of bytes of press layer data
		float *samples_in,	// array of input samples
		int   n			// number of samples in samples_in
		);

void wave_get_size(void *wv, unsigned long *bytes);

int main(int argc, char *argv[])
{
	FILE *fp;
	float *buffer;
	int i = 0;
	float dummy;			
	
	if (argc != 2) {
		printf("usage: tcid InputFile\n");
		exit(0);
	}

	// load text file of floats, text file format used so Matlab
	// tx (tsig.m) can be used

	fp = fopen(argv[1],"rt");
	assert(fp != NULL);
			
	while (!feof(fp))
	{
		fscanf(fp,"%f/n",&dummy);
		i++;
	}

	buffer = (float*)malloc(sizeof(float)*i);
	assert(buffer != NULL);
	i = 0;
	fseek(fp, SEEK_SET, 0l);

	while (!feof(fp))
	{
		fscanf(fp,"%f/n",&buffer[i]);
		i++;
	}
	fclose(fp);

	vpb_cid_debug_on("../callerid/mal.txt");

	try {
		#ifdef BIT_SYNC_ONLY
		extract_presentation_layer_message(ascii, &nascii, buffer, i) ;
		#else

		// demod and bit_sync in C
		
		char number_str[VPB_MAX_STR];
		
		// convert float to short

		short *buf = new short[i];
		assert(buf != NULL);
		int j;
		for(j=0; j<i; j++)
			buf[j] = (short)buffer[j];
		
		vpb_cid_decode(number_str, buf, i);
		printf("number = %s\n",number_str);
		
		#endif
	}

	/*
		This code can read wave files directly
	try {
		void *w;
		unsigned long sz_bytes;
		
		vpb_wave_open_read(&w, argv[1]);
		wave_get_size(w, &sz_bytes);
		char *buf = new char[sz_bytes];
		assert(buf != NULL);
		vpb_wave_read(w, buf, sz_bytes);
		vpb_decode_cid((short*)buf, sz_bytes/sizeof(short));

	}
	*/
	catch(Wobbly w) {
		char s[VPB_MAX_STR];
		w.translate(s);
		printf("Error: %s\n",s);
		return 1;
	}	

	free(buffer);
	printf("Packet recieved OK!\n");
	return 0;
}
